using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Outbound_OpenInterface_Test_App.OutboundCampaignWS;
using System.Web.Services.Protocols;

namespace Outbound_OpenInterface_Test_App
{
  public partial class Add_Contact : Form
  {
    OWCampaigns This_Campaign_List;
    int This_Selected_Index;
    DataTable This_Data_Table;
    int CF_Counter = 0;

    public Add_Contact(OWCampaigns Campaign_List, int Selected_Index, DataTable DataTable)
    {
      InitializeComponent();
      This_Campaign_List = Campaign_List;
      This_Selected_Index = Selected_Index;
      This_Data_Table = DataTable;
      
      Campaign_Name_Field.Text = This_Campaign_List.CampaignList[This_Selected_Index].Name;

      //add custom fields to the dialog
      int y_loc = 230;
      int total_y_Added = 0;
      int tab_index = 9;
      CF_Counter = 0;

      foreach(DataColumn This_Column in This_Data_Table.Columns)
      {
        if(This_Column.Caption == "CF_Field")
        {
          //crete new label & text fields
          CF_Label = new System.Windows.Forms.Label();
          CF_Field = new System.Windows.Forms.TextBox();

          //add new label field
          CF_Label.AutoSize = true;
          CF_Label.Location = new System.Drawing.Point(4, (y_loc + total_y_Added + 2));
          CF_Label.Name = This_Column.ColumnName+"_Label";
          CF_Label.RightToLeft = System.Windows.Forms.RightToLeft.No;
          CF_Label.Size = new System.Drawing.Size(92, 13);
          CF_Label.TextAlign = ContentAlignment.MiddleRight;
          CF_Label.TabIndex = tab_index + 999;
          CF_Label.Text = This_Column.ColumnName;

          //add new text field
          CF_Field.Location = new System.Drawing.Point(103, (y_loc + total_y_Added));
          CF_Field.Name = This_Column.ColumnName+"_Field";
          CF_Field.Size = new System.Drawing.Size(92, 20);
          CF_Field.TabIndex = tab_index;

          //add to group box
          groupBox2.Controls.Add(this.CF_Label);
          groupBox2.Controls.Add(this.CF_Field);

          //update location variables
          total_y_Added += 24;
          tab_index++;
          CF_Counter++;
        }
      }
      //update the rest of the box to fit the new fields    
      //update window
      Size This_Size;
      Point This_Location;
      This_Size = this.ClientSize;
      This_Size.Height += total_y_Added;
      this.ClientSize = This_Size;

      //update groupbox
      This_Size = groupBox2.Size;
      This_Size.Height += total_y_Added;
      groupBox2.Size = This_Size;

      //update submit button
      This_Location = Add_Contact_Button.Location;
      Add_Contact_Button.TabIndex = tab_index;
      This_Location.Y += total_y_Added;
      Add_Contact_Button.Location = This_Location;

      //update message label
      This_Location = Message_Label.Location;
      This_Location.Y += total_y_Added;
      Message_Label.Location = This_Location;
    }

    private void Add_Contact_Button_Click(object sender, EventArgs e)
    {
      //get values
      OutboundCampaignWS.OWContact contDetails = new OWContact();
      OutboundCampaignWS.OutboundCampaignWS campInvoke = new OutboundCampaignWS.OutboundCampaignWS();

      //name
      contDetails.FirstName = F_Name_Field.Text;
      contDetails.LastName = L_Name_Field.Text;
      
      //contact no
      contDetails.PhoneNumber = new OWPhoneNumber();
      contDetails.PhoneNumber.IntCode = Int_Code_Field.Text;
      contDetails.PhoneNumber.AreaCode = Area_Code_Field.Text;
      contDetails.PhoneNumber.PhoneNo = Phone_No_Field.Text;
      
      //email address
      contDetails.EmailAddress = Email_Field.Text;




      try
      {
          if (Skillset_ID.Text != "")
          {
              //ensure numberic
              long temp = System.Convert.ToInt32(Skillset_ID.Text);
              contDetails.SkillsetID = temp;
          }
          else
          {
              Message_Label.Text = "Skillset ID must be Numeric and Valid";
          }
      }
      catch
      {
          Message_Label.Text = "Skillset ID must be Numeric and Valid";
      }
      

      //prefered agent id
      try
      {
        if(Prefered_Agent_Field.Text != "")
        {
          contDetails.PreferredAgentID = System.Convert.ToInt32(Prefered_Agent_Field.Text);
          contDetails.PreferredAgentSpecified1 = true;
        }
        else
        {
          contDetails.PreferredAgentSpecified1 = false;
        }
      }
      catch
      {
        Message_Label.Text = "Prefered Agent ID must be Numeric and Valid";
      }

      //custom fields
      contDetails.CustomFieldList = new OutboundCampaignWS.OWCustomField[CF_Counter];
      int i = 0;
      foreach(DataColumn This_Column in This_Data_Table.Columns)
      {
        if(This_Column.Caption == "CF_Field")
        {
          Control Holder = FindControlByName(This_Column.ColumnName.ToString() + "_Field");

          contDetails.CustomFieldList[i] = new OWCustomField();
          contDetails.CustomFieldList[i].Name = This_Column.ColumnName.ToString();
          contDetails.CustomFieldList[i].Text = Holder.Text;

          i++;
        }
      }

      try
      {

        long campaignID = This_Campaign_List.CampaignList[This_Selected_Index].ID;
        int result = campInvoke.AppendContactsToCampaign(System.Convert.ToInt32(campaignID), contDetails, GlobalDef.getInstance().MySessionKey);
        if(result == 1)
        {
          Message_Label.Text = "Contact Added";
        }
        else
        {
          Message_Label.Text = "Contact Not Added";
        }
        Message_Label.Refresh();
      }
      catch(SoapException ex)
      {
        if(ex.Detail.InnerText.Contains("1 sec"))
        {
          Message_Label.Text = "Can only be called once every 1 seconds";
          Message_Label.Refresh();
        }
        else
        {
          Message_Label.Text = "Error : " + ex.Detail.InnerText;
        }
      }
    }

    /// <summary>
    /// Get a handle to the a control in the groupbox2
    /// </summary>
    /// <param name="name"></param>
    /// <returns>control</returns>
    private Control FindControlByName(string name)
    {
      //get all controls in the groupbox2 area
      foreach (Control c in groupBox2.Controls)
      {
          if (c.Name == name)
              return c;
      }

      return null; //not found
    }
  }
}